<?php
/* --------------------------------------------------------------
 LanguageValues.php 2019-12-19
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Models\Read;

/**
 * Class LanguageValues
 * @package Gambio\Core\Configuration\Models
 */
class LanguageValues
{
    /**
     * @var array
     */
    private $values;
    
    
    /**
     * Values constructor.
     *
     * @param array $values
     */
    private function __construct(array $values)
    {
        $this->values = $values;
    }
    
    
    /**
     * Factory method for values.
     *
     * @param array $values
     *
     * @return static
     */
    public static function fromArray(array $values): self
    {
        return new static($values);
    }
    
    
    /**
     * @return array
     */
    public function toArray(): array
    {
        return $this->values;
    }
}